#!/usr/bin/env python

import os
import sys
import gtk

class  App:
	def __init__(self, cwdir):
		self.cwdir = cwdir
		
		builder = gtk.Builder()
		builder.add_from_file(cwdir+"/interface.glade")
		builder.connect_signals(self)
		self.label = builder.get_object("Label")
		self.label.set_text("")
		self.volmeter = builder.get_object("Volume")
		
		self.connect()
	
	def printplaying(self):
		pass
		#line = ""
		#while (line[0:7] != "Playing"):
		#	line = self.ssho.readline()
		#self.label.set_text(line)
	
	def playrand(self, widget, data=None):
		if (self.active):
			try:
				print self.sshin.write(self.ctrlsh+"playrand\n"), self.sshin.flush()
				self.printplaying()
			except:
				self.active = False
				self.sshin.close()
				self.ssho.close()
				self.label.set_text("Connection Terminated.")

	def playall(self, widget, data=None):
		if (self.active):
			try:
				self.sshin.write(self.ctrlsh+"playall\n")
				self.sshin.flush()
				self.printplaying()
			except:
				self.active = False
				self.sshin.close()
				self.ssho.close()
				self.label.set_text("Connection Terminated.")

	def stop(self, widget, data=None):
		if (self.active):
			try:
				self.sshin.write(self.ctrlsh+"stop\n")
				self.sshin.flush()
			except:
				self.active = False
				self.sshin.close()
				self.ssho.close()
				self.label.set_text("Connection Terminated.")

	def next(self, widget, data=None):
		if (self.active):
			try:
				self.sshin.write(self.ctrlsh+"next\n")
				self.sshin.flush()
				self.printplaying()
			except:
				self.active = False
				self.sshin.close()
				self.ssho.close()
				self.label.set_text("Connection Terminated.")
	
	def previous(self, widget, data=None):
		if (self.active):
			try:
				self.sshin.write(self.ctrlsh+"prev\n")
				self.sshin.flush()
				self.printplaying()
			except:
				self.active = False
				self.sshin.close()
				self.ssho.close()
				self.label.set_text("Connection Terminated.")

	def pause(self, widget, data=None):
		if (self.active):
			try:
				self.sshin.write(self.ctrlsh+"pause\n")
				self.sshin.flush()
			except:
				self.active = False
				self.sshin.close()
				self.ssho.close()
				self.label.set_text("Connection Terminated.")

	def volume(self, widget, data):
		if (self.active):
			try:
				if (self.volset == self.volfactor):
					self.sshin.write("amixer set Playback "+str(round(50+data*50))+"% &&")
					self.sshin.write("amixer set Headphone "+str(50+data*50)+"%\n")
					self.sshin.flush()
					self.volset = 0
				else:
					self.volset += 1
			except:
				self.active = False
				self.sshin.close()
				self.ssho.close()
				self.label.set_text("Connection Terminated.")
	
	def volume_end(self, widget, data=None):
		if (self.active):
			try:
				self.volume = round(50+self.volmeter.get_value()*50)
				self.sshin.write("amixer set Playback "+str(self.volume)+"% &&")
				self.sshin.write("amixer set Headphone "+str(self.volume)+"%\n")
				self.sshin.flush()
			except:
				self.active = False
				self.sshin.close()
				self.ssho.close()
				self.label.set_text("Connection Terminated.")
	
	def connect(self):
		try:
			configfile = open(os.path.join(self.cwdir, "config"), "r")
			lines = configfile.readlines()
			configfile.close()
			
			config = {"SSH_CONNECT":"", "MPLAYER_CONTROLSH_PATH":"", "INITIAL_VOLUME":""}

			for line in lines:
				splitted = list(line.partition("="))
				if (splitted[1] == "="):
					splitted[0] = splitted[0].strip().strip("\"")
					splitted[2] = splitted[2].strip().strip("\"")
					print splitted
					config[splitted[0]] = splitted[2]

			self.ctrlsh = config["MPLAYER_CONTROLSH_PATH"]+" "
			initvol = config["INITIAL_VOLUME"]
			sshstring = config["SSH_CONNECT"]

			self.sshin, self.ssho = os.popen4(sshstring)
			self.sshin.write("amixer set Playback "+initvol+"% && amixer set Headphone "+initvol+"%\n")
			self.sshin.flush()
		
			self.volset, self.volfactor = 0, 5 #Anti-SSH-Flood
			self.volume = int(initvol)
		except:
			self.label.set_text("Config or SSH Error!")
			self.active = False
		else:
			self.active = True
			self.label.set_text("Connected.")
	
	def start(self):
		gtk.main()
	
	def quit(self, widget, data=None):
		try:
			self.sshin.close()
			self.ssho.close()
		except:
			pass
		else:
			gtk.main_quit()

if (__name__ == "__main__"):
	os.chdir(os.path.abspath(os.path.dirname(sys.argv[0])))
	cwdir = os.getcwd()
	app = App(cwdir)
	app.start()
